﻿var windowParams = 'toolbar=no, scrollbars=yes, status=no, resizable=yes, location=no, menubar=no, directories=no, width=768, height=720';

function Live() {
    this.isLoading = false;
    this.scriptIsLoaded = false;
    this.cssIsLoaded = false;

    var hasVisitorToken = localStorage.chat_session &&
        JSON.parse(localStorage.chat_session).chatSession &&
        Boolean(JSON.parse(localStorage.chat_session).chatSession.visitorToken);

    const startChat = function (data) {
        // Create chat instance after script is loaded
        window.Live = new LiveChat();
        // relaunch the chat
        if (!hasVisitorToken) {
            window.Live.launch(data);
        }
    }

    this.loadCSS = function (data) {
        var chatCss = document.createElement('link');
        var chatCssHref = window.chatVersion ?
            'https://spa-packages.siteground.com/clients-frontend/' + chatVersion + '/main.css':
            '/impulse/dist/main.css';

        chatCss.setAttribute('rel', 'stylesheet');
        chatCss.setAttribute('type', 'text/css');
        chatCss.setAttribute('href', chatCssHref);
        chatCss.onload = function () {
            Live.cssIsLoaded = true;

            if (Live.scriptIsLoaded) {
                startChat(data)
            }
        };
        chatCss.onerror = function () {
            Live.isLoading = false;
        }

        document.head.appendChild(chatCss);
    }

    this.loadJS = function (data) {
        var chatScript = document.createElement('script');
        var chatScriptSrc = window.chatVersion ?
            'https://spa-packages.siteground.com/clients-frontend/' + chatVersion + '/main.js':
            '/impulse/dist/main.js';

        chatScript.setAttribute('src', chatScriptSrc);
        chatScript.onload = function () {
            Live.scriptIsLoaded = true;

            if (Live.cssIsLoaded) {
                startChat(data)
            }
        };
        chatScript.onerror = function () {
            Live.isLoading = false;
        }

        document.head.appendChild(chatScript);
    }

    this.launch = function (event, data) {
        if (event) {
            event.preventDefault()
        }

        if (this.isLoading) {
            return;
        }

        this.isLoading = true;
        this.loadJS(data);
        this.loadCSS(data);
    }

    if (hasVisitorToken) {
        this.launch();
    }
}

function LiveChat()
{
    let chatStarted = false;
    this.chatwin = false;
    // this.refurl = escape(document.referrer);
    this.page = escape(document.location.href);

    this.setPage = function (page)
    {
        this.page = page;
        return this;
    }

    if (typeof chat_lang == 'undefined') {
        chat_lang = 'en'
    }

	// initializes clients-fe
	ClientsFrontend.triggerEvent(ClientsFrontend.EVENTS.SG_SITE_PAGE_LOADED, { environment: window.environment, language: chat_lang  });

	ClientsFrontend.onEvent(ClientsFrontend.EVENTS.CANNOT_START_NEW_SALES_CHAT_DUE_TO_PROBABILITY, function() {
		console.log('launchOldChat')
		Live.launchOldChat( );
	});

    ClientsFrontend.onEvent(ClientsFrontend.EVENTS.ON_AFTER_CHAT_RENDER, function() {
        const popup = document.getElementById('chat-popup');

        if (popup){
            popup.style.visibility = 'hidden'
        }
    });

    ClientsFrontend.onEvent(ClientsFrontend.EVENTS.ON_AFTER_CHAT_CLOSE, function() {
        const popup = document.getElementById('chat-popup');

        if (popup && !chatStarted){
            popup.style.visibility = 'initial'
        }
    });

    ClientsFrontend.onEvent(ClientsFrontend.EVENTS.ON_AFTER_CHAT_STARTED, function() {
        const popup = document.getElementById('chat-popup');

        chatStarted = true;
        writeCookie('chatPopupMustBeVisibleRightAway',0, 1);

        if (popup){
            popup.style.visibility = 'hidden'
        }
    });

	this.verification = function( oid )
	{
		var url = chatUrl + '/request?verify=1&oid=' + oid + '&page=' + this.page;
		this.chatwin = window.open( url, 'guest_0', windowParams);
	}

	this.launchOldChat = function ( )
	{
		var url = chatUrl + '?page=' + this.page;

		if ( typeof( locale_id ) !== 'undefined' )
		 url += '&locale_id=' + locale_id;
		if ( typeof( chatpromo ) !== 'undefined' )
		 url += '&promo=' + chatpromo;
		if ( typeof( cur_code ) !== 'undefined' )
		 url += '&cur_code=' + cur_code;
		if ( typeof( local_phone ) !== 'undefined' )
		 url += '&local_phone=' + local_phone;

		this.chatwin = window.open( url, 'guest_0', windowParams);
		if (this.chatwin.opener == null)
		 this.chatwin.opener = self;
	}

	this.launch = function(data) {
        if (!ClientsFrontend) {
          return;
        }
        ClientsFrontend.chat.executeIfChatIsNotOpen(() => {
            ClientsFrontend.triggerEvent(ClientsFrontend.EVENTS.START_CHAT_PRESALE, {
                environment: window.environment,
                currency: cur_code,
                promo: chatpromo,
                campaign: (data && data.campaign) || window.chat_campaign,
                autoStart: data && data.autoStart,
                popup: data && data.popup,
                serviceCompanyId: serviceCompanyId
            });
        });
	}
}

window.Live = new Live();
