﻿/*global site_vars, jQuery, grecaptcha*/
var $g_recaptcha;

/* Captcha Callback */
window.onloadCallbackNameboy = function() {
    grecaptcha.render( 'g_recaptcha', {
        'sitekey' : site_vars.recapt_key, // Replace this
        'callback' : onsolveCallbackNameboy
    });
};
window.onsolveCallbackNameboy = function( g_recaptcha_response ) {
    queryNames( parseInt( $pageNum.val(), 10 ), g_recaptcha_response );
    $('#recapp').val(g_recaptcha_response);
};

jQuery(document).ready(function ($){

    $('#search-submit').removeAttr('disabled');

    $('#search-input').on('keyup', function (e) {
        if (e.keyCode == 13) {
            e.preventDefault();
            return process_form();
        }
    });

    $('#search-submit').on('click', function(e) {
        e.preventDefault();
        return process_form();
    });

    var search_nonce = window.site_vars.search_nonce;

    var after_ajax_dom = function(response) {
        if (typeof response.data.serno !== 'undefined' ) {
            search_nonce = response.data.serno;
        }
        $('#search-submit').removeAttr('disabled').removeClass('disabled');
        $('.input-n-search').removeClass('loading');
    };

    var after_ajax_error_alert = function() {
        alert('We are having some unexpected technical difficulties. Please reload the page and try again.');
    };

    var onsolveCallbackWpbTd = function( g_recaptcha_response ) {
        process_form( g_recaptcha_response );
    };

    window.onloadCallbackWpbTd = function() {
        grecaptcha.render( 'g_recaptcha', {
            'sitekey' : site_vars.recapt_key,
            'callback' : onsolveCallbackWpbTd
        } );
    };

    var gen_scr_req;
    var gen_scr = function(domain) {
        var $imCon = $('body').find('.scrsht-im'),
            $imLoader = $imCon.find('.loaderc'),
            $immaCon = $imCon.find('.imma-con');
        $immaCon.hide();
        $imLoader.show();
        var post_data = { _ajax_nonce: search_nonce,
            action: 'scrsht',
            dataType: 'json',
            q: domain
        };
        gen_scr_req = $.post(site_vars.ajax_url, post_data, function(response){
            if ( response.success ) {
                if (response.data.image != '') {
                    $immaCon.html('<img src="' + response.data.image + '" class="previewimg" />');
                } else {
                    $immaCon.html('<img src="' + site_vars.asurl + '/assets/img/no-image-icon.jpg" class="previewimg" />');
                }
            } else {
                $immaCon.html('<img src="' + site_vars.asurl + '/assets/img/no-image-icon.jpg" class="previewimg" />');
            }
        }).fail(function() {
            $immaCon.html('<img src="' + site_vars.asurl + '/assets/img/no-image-icon.jpg" class="previewimg" />');
        }).always(function() {
            $immaCon.show();
            $imLoader.hide();
        });
    };

    /* Containers */
    var $errorBox = $( '.error_box' );

    var process_form = function( recap ) {
        var $results = $('.results'),
            $input = $('.input-n-search');

        $results.html('').hide();

        $errorBox.removeClass( 'show' );

        if ( recap === undefined ) {
            recap = '';
        }
        if (typeof gen_scr_req !== 'undefined') {
            gen_scr_req.abort();
        }
        var sitenamein = $('#search-input').val();
        if ( sitenamein == '' ) {
            return false;
        }
        $('#search-submit').attr('disabled', 'disabled').addClass('disabled');

        var post_data = {
            _ajax_nonce: search_nonce,
            action: 'get_result',
            dataType: 'json',
            q: sitenamein,
            recapt: recap
        };

        $('#results').html('');

        $input.addClass('loading');
        $.post(site_vars.ajax_url, post_data, function(response) {
            if (typeof response.success !== 'boolean' || !response.data.html) {
                after_ajax_error_alert();
                after_ajax_dom(response);
                return false;
            }

            $g_recaptcha = $( '.g-recaptcha' );
            $g_recaptcha.show();

            if ( response.data.method == 'noop' ) {
                $g_recaptcha.show();
                after_ajax_dom(response);
                return false;
            }

            if ( typeof response.success === 'boolean' && response.success === false  && response.data.html ) {
                if ( $g_recaptcha.is( ':visible' ) ) {
                    $g_recaptcha.hide();
                    grecaptcha.reset();
                }
                $errorBox.html( response.data.html ).addClass( 'show' );
                after_ajax_dom(response);
                return false;
            }

            $results.html(response.data.html).show();
            $('html, body').animate({
                scrollTop: $results.offset().top
            }, 500);

            gen_scr( sitenamein );

            after_ajax_dom(response);
            if ( $g_recaptcha.is( ':visible' ) ) {
                $g_recaptcha.hide();
                grecaptcha.reset();
            }
        })
        .fail(function(response) {
            after_ajax_dom(response);
        })
        .always(function(response) {
            if (typeof response.data.serno !== 'undefined' ) {
                search_nonce = response.data.serno;
                process_form(recap);
            } else {
                after_ajax_dom(response);
            }
        });
        return false;
    };
});
