﻿const DEFAULT_CURRENCY_CODE = 'USD';
const DEFAULT_CURRENCY_ID = 1;
const DEFAULT_LOCATION = 'us';
const DEFAULT_LANGUAGE = 'en';

/* global $ */

$(function () {
	var cookie_currency = a2.cookie.get('currencycode');
	var cookie_location = a2.cookie.get('location');
	var cookie_phone = a2.cookie.get('phone');
	// Set currency to
	if (cookie_currency === null) {
		a2.cookie.set('currencycode', DEFAULT_CURRENCY_CODE);
	}
	if (cookie_location == null) {
		a2.cookie.set('location', DEFAULT_LOCATION);
	}

	if (a2.cookie.get('set_whmcs_currency') == 1) {  //used to be double nested inside a document.ready() block
		/* We need to set our currency cookie on WHMCS */
		a2.cookie.whmcs('currency', DEFAULT_CURRENCY_ID);
	}

	$('a.search').on('click', function (e) {
		e.preventDefault();
		setTimeout(function () {
			$('input.form-control[name="keywords"]').focus();
		}, 100);
	});

	//FAQ-Accodian

	var dataHolder = $('.faq-item .faq-ans');
	var mainItem = $('.faq-item .faq-question');

	$(".faq-item .faq-question.current").parent().find('.faq-ans').slideDown();

	$('.faq-item .faq-question').click(function () {
		if ($(this).parent().hasClass('current')) {
			$(this).parent().removeClass('current');
			$(this).next().slideUp("fast");
		}
		else {
			dataHolder.slideUp("fast");
			mainItem.parent().removeClass('current');
			$(this).parent().addClass('current');
			$(this).next().slideDown("fast");
			return false;
		}
	});

});

/**
 *
 * Capturing GET requests to KB search pages to inject into form and submit
 *
 */

$.extend({ // Extending jQuery to add getUrlVars function
	getUrlVars: function () {
		var vars = [], hash;
		var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
		for (var i = 0; i < hashes.length; i++) {
			hash = hashes[i].split('=');
			vars.push(hash[0]);
			vars[hash[0]] = hash[1];
		}
		return vars;
	},
	getUrlVar: function (name) {
		return $.getUrlVars()[name];
	}
});
$(function () {
	var kb_search = $.getUrlVar('keyword');
	if (kb_search && $('#search_box_large').length) {
		kb_search = decodeURIComponent(kb_search);
		$('#search-request').val(kb_search);
		$('#search_box_large').submit();
	}
});

/* ==========================================================================
   Match Height
   ========================================================================== */
!function (t) { var e = -1, a = -1, o = function (t) { return parseFloat(t) || 0 }, i = function (e) { var a = 1, i = t(e), n = null, r = []; return i.each(function () { var e = t(this), i = e.offset().top - o(e.css("margin-top")), s = r.length > 0 ? r[r.length - 1] : null; null === s ? r.push(e) : Math.floor(Math.abs(n - i)) <= a ? r[r.length - 1] = s.add(e) : r.push(e), n = i }), r }, n = function (e) { var a = { byRow: !0, property: "height", target: null, remove: !1 }; return "object" == typeof e ? t.extend(a, e) : ("boolean" == typeof e ? a.byRow = e : "remove" === e && (a.remove = !0), a) }, r = t.fn.matchHeight = function (e) { var a = n(e); if (a.remove) { var o = this; return this.css(a.property, ""), t.each(r._groups, function (t, e) { e.elements = e.elements.not(o) }), this } return this.length <= 1 && !a.target ? this : (r._groups.push({ elements: this, options: a }), r._apply(this, a), this) }; r.version = "master", r._groups = [], r._throttle = 80, r._maintainScroll = !1, r._beforeUpdate = null, r._afterUpdate = null, r._rows = i, r._parse = o, r._parseOptions = n, r._apply = function (e, a) { var s = n(a), h = t(e), c = [h], l = t(window).scrollTop(), p = t("html").outerHeight(!0), d = h.parents().filter(":hidden"); return d.each(function () { var e = t(this); e.data("style-cache", e.attr("style")) }), d.css("display", "block"), s.byRow && !s.target && (h.each(function () { var e = t(this), a = e.css("display"); "inline-block" !== a && "inline-flex" !== a && (a = "block"), e.data("style-cache", e.attr("style")), e.css({ display: a, "padding-top": "0", "padding-bottom": "0", "margin-top": "0", "margin-bottom": "0", "border-top-width": "0", "border-bottom-width": "0", height: "100px", overflow: "hidden" }) }), c = i(h), h.each(function () { var e = t(this); e.attr("style", e.data("style-cache") || "") })), t.each(c, function (e, a) { var i = t(a), n = 0; if (s.target) n = s.target.outerHeight(!1); else { if (s.byRow && i.length <= 1) return void i.css(s.property, ""); i.each(function () { var e = t(this), a = e.css("display"); "inline-block" !== a && "inline-flex" !== a && (a = "block"); var o = { display: a }; o[s.property] = "", e.css(o), e.outerHeight(!1) > n && (n = e.outerHeight(!1)), e.css("display", "") }) } i.each(function () { var e = t(this), a = 0; s.target && e.is(s.target) || ("border-box" !== e.css("box-sizing") && (a += o(e.css("border-top-width")) + o(e.css("border-bottom-width")), a += o(e.css("padding-top")) + o(e.css("padding-bottom"))), e.css(s.property, n - a + "px")) }) }), d.each(function () { var e = t(this); e.attr("style", e.data("style-cache") || null) }), r._maintainScroll && t(window).scrollTop(l / p * t("html").outerHeight(!0)), this }, r._applyDataApi = function () { var e = {}; t("[data-match-height], [data-mh]").each(function () { var a = t(this), o = a.attr("data-mh") || a.attr("data-match-height"); o in e ? e[o] = e[o].add(a) : e[o] = a }), t.each(e, function () { this.matchHeight(!0) }) }; var s = function (e) { r._beforeUpdate && r._beforeUpdate(e, r._groups), t.each(r._groups, function () { r._apply(this.elements, this.options) }), r._afterUpdate && r._afterUpdate(e, r._groups) }; r._update = function (o, i) { if (i && "resize" === i.type) { var n = t(window).width(); if (n === e) return; e = n } o ? -1 === a && (a = setTimeout(function () { s(i), a = -1 }, r._throttle)) : s(i) }, t(r._applyDataApi), t(window).on("load", function (t) { r._update(!1, t) }), t(window).on("resize orientationchange", function (t) { r._update(!0, t) }) }(jQuery);
/* ========================================================================== */

function setupOwlSlider(elementQuery) {
	that = elementQuery;
	if (that.length == 0) {
		return;
	}

	let carouselConfig = {
		items: 4,
		nav: true,
		dots: true,
		margin: 2,
		loop: false,
		touchDrag: false,
		mouseDrag: false,
		autoplay: false,
		navText: false,
		responsive: {
			0: {
				items: 1,
			},
			320: {
				items: 1,
			},
			480: {
				items: 1,
			},
			600: {
				items: 1,
			},
			767: {
				items: 2,

			},
			991: {
				items: 3,
			},
			1200: {
				items: 4,
			}

		}

	};
	if (matrixStartPosition) {
		carouselConfig.startPosition = matrixStartPosition;
	}
	var owl = that.owlCarousel
		(carouselConfig);


	return owl;
}

function fixMatrixHeights() {
	$rows = $(".match_row_height_parent");
	if ($rows.length == 0) return;

	$rows.each(function () {
		var parent = $(this);
		var matchData = parent.data('mh');
		// remove 'element' style
		this.style.height = null;
		var height = parent.height();
		var children = $(".match_row_" + matchData);
		children.each(function (index, element) {
			var child = $(element);
			// remove 'element' style
			element.style.height = null;
			var childHeight = child.height();
			if (childHeight > height) {
				height = childHeight;
			}
		});
		children.height(height);
		parent.height(height);
	});
}

function setupOwlSliderLayout(matrix_id) {
	var matrix_selector = '#cmp-plan-section-' + matrix_id;
	var floatpanel_selector = '#float-panel-' + matrix_id;
	// new matrix stuff 2020-10-23

	// link the click of our sync-prev/next buttons to the clicking of all the owl-prev/next buttons
	// in the carosel.
	var section = $(matrix_selector);
	var a2Prev = section.find('.synch-prev');
	var a2Next = section.find('.synch-next');
	a2Prev.click(function () {
		section.find("button.owl-prev").trigger('click');
	});
	a2Next.click(function () {
		section.find("button.owl-next").trigger('click');
	});

	// hide all buttons, then use the ones in the header as our guide on
	// whether or not to show the prev/next button

	a2Prev.addClass("disabled");
	a2Next.addClass("disabled");
	var plans = section.find('.cmp-plans');
	var owlItems = plans.find('.owl-item');
	// intial set of the nav buttons
	if (!owlItems.last().hasClass('active')) {
		a2Next.removeClass("disabled");
	}

	if (!owlItems.first().hasClass('active')) {
		a2Prev.removeClass("disabled");
	}
	// maintain nav buttons as we go
	plans.on('changed.owl.carousel', function (event) {
		updatePrevNext(section);
	});
	plans.on('resized.owl.carousel', function (event) {
		updatePrevNext(section);
	});
	plans.on('translated.owl.carousel', function (event) {
		updatePrevNext(section);
	});
	var planContent = section.find('.cmp-plan-content');
	var planTop = section.find('.cmp-plan-top');
	var sectionSpacer = section.find('.cmp-plan-section-spacer');
	var tableEnd = section.find('.table-end');
	var floatPanel = $(floatpanel_selector);

	if (planContent.length > 0
		&& tableEnd.length > 0) {

		var wp1 = new Waypoint({
			element: planContent[0],
			handler: function (direction) {
				planTop.toggleClass('fixed', direction === 'down');
				sectionSpacer.toggleClass('fixed', direction === 'down');
			},
			offset: 0
		});

		var wp2 = new Waypoint({
			element: $('.float-panel-show')[0],
			handler: function (direction) {
				floatPanel.toggleClass('fixed', direction === 'down');
			},
			offset: 0
		});

		var wp3 = new Waypoint({
			element: tableEnd[0],
			handler: function (direction) {
				planTop.toggleClass('fixed', direction === 'up');
				sectionSpacer.toggleClass('fixed', direction === 'up');
			},
			offset: '25%'
		});

		var wp4 = new Waypoint({
			element: tableEnd[0],
			handler: function (direction) {
				floatPanel.toggleClass('fixed', direction === 'up');
			}
		});
	}
	var accTableData = $('.info-box');
	var accTableItem = planContent.find("div.drp");
	$(accTableItem).click(function () {

		if ($(this).hasClass('open')) {
			$(this).removeClass('open');
			$(this).find(".info-box").slideUp(100);
		}
		else {
			accTableData.slideUp(100);
			accTableItem.removeClass('open');
			$(this).addClass('open');
			$(this).find(".info-box").slideDown(100);
			return false;
		}
	});


	$('.go-down').on('click', function () {
		if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
			var target = $(this.hash);
			target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
			if (target.length) {
				$('html,body').animate({
					scrollTop: target.offset().top
				}, 800);

				return false;
			}
		}
	});
	var alinks = floatPanel.find('a');
	alinks.first().addClass("active");

	alinks.on('click', function () {
		alinks.removeClass("active");
		$(this).addClass("active");
	});
}

var resizeTimer;
$(window).on('resize', delayedTimerActions);

function delayedTimerActions() {
	clearTimeout(resizeTimer);

	resizeTimer = setTimeout(function () {
		fixMatrixHeights();
		Waypoint.refreshAll();
	}, 500);
}

function featureDropdownHandler() {
	var featuresLinks = $("a.features");
	featuresLinks.off('click');
	featuresLinks.off('mouseenter');
	featuresLinks.off('mouseleave');
	featuresLinks.on('click', function (event) {
		event.preventDefault();
	});
	if ($(window).width() < 991) {
		featuresLinks.each(function (index, elem) {
			var $id = $(elem).attr('id');
			var features = $(".view-details[data-feature-id='" + $id + "']");
			$(elem).on('click', function () {
				var isvisible = features.is(':visible');
				$(".view-details:visible").hide();
				features.toggle(isvisible === false);
			});

		});
	} else {
		featuresLinks.each(function (index, elem) {
			var $id = $(elem).attr('id');
			var features = $(".view-details[data-feature-id='" + $id + "']");

			$(elem).on('mouseenter', function () {
				features.stop(true, false).toggle(true);
			}).on('mouseleave', function () {
				features.stop(true, false).toggle(false);
			});

		});
	}
};

function modifiedReloadedMatrixSliderLayout(section) {
	var a2Prev = section.find('.synch-prev');
	var a2Next = section.find('.synch-next');
	a2Prev.click(function () {
		section.find("button.owl-prev").trigger('click');
	});
	a2Next.click(function () {
		section.find("button.owl-next").trigger('click');
	});
	a2Prev.addClass("disabled");
	a2Next.addClass("disabled");

	var plans = section.find('.cmp-plans');
	var owlItems = plans.find('.owl-item');
	// intial set of the nav buttons
	if (!owlItems.last().hasClass('active')) {
		a2Next.removeClass("disabled");
	}

	if (!owlItems.first().hasClass('active')) {
		a2Prev.removeClass("disabled");
	}

	// maintain nav buttons as we go
	plans.on('changed.owl.carousel', function (event) {
		updatePrevNext(section);
	});
	plans.on('resized.owl.carousel', function (event) {
		updatePrevNext(section);
	});
	plans.on('translated.owl.carousel', function (event) {
		updatePrevNext(section);
	});

	var content = section.find('.cmp-plan-content');
	var tableEnd = section.find('.table-end');

	if (content.length > 0 &&
		tableEnd.length > 0) {

		var wp1 = new Waypoint({
			element: content[0],
			handler: function (direction) {
				adjustMatrixHeaderPosition(section, direction);
			},
			offset: 0
		});

		var wp3 = new Waypoint({
			element: tableEnd[0],
			handler: function (direction) {
				section.find('.cmp-plan-top').toggleClass('invisible', direction === 'down');
				section.find('.cmp-plan-section-spacer').toggleClass('invisible', direction === 'down');
			},
		});
	}

	var accTableData = section.find('.info-box');
	var accTableItem = section.find('.cmp-plan-content div.drp');
	$(accTableItem).click(function () {
		var that = $(this);
		if (that.hasClass('open')) {
			that.removeClass('open');
			that.find(".info-box").slideUp(100);
		} else {

			accTableData.slideUp(100);
			accTableItem.removeClass('open');

			that.addClass('open');
			that.find(".info-box").slideDown(100);
			that.find(".info-box").css("top", that.height() + 19);
			return false;
		}
	});


	section.find('.go-down').on('click', function () {

		if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
			var target = $(this.hash);
			//alert(($('[name=' + this.hash.slice(1) + ']').offset().top)+344);
			target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
			if (target.length) {
				$('html,body').animate({
					scrollTop: target.offset().top - 360
				}, 400);

				return false;
			}
		}
	});

	$(".on-page-nav > div > ul > li a").on('click', function () {
		$(".on-page-nav > div > ul > li a").removeClass("active");
		$(this).addClass("active");
	});

	$(".on-page-nav > div > ul > li:first-child a").addClass("active");

}
function adjustMatrixHeaderPosition(context, direction) {
	if (direction == "down") {
		delayedTimerActions();
		context.find('.cardBox').addClass('smallCardBox');
		context.find('.cmp-plan-top .owl-item').addClass('small'); //hide();
	}
	if (direction == "up") {

		delayedTimerActions();
		context.find('.cardBox').removeClass('smallCardBox');// show();
		context.find('.cmp-plan-top .owl-item').removeClass('small');
	}
	context.find('.cmp-plan-top').toggleClass('fixed', direction === 'down');
	context.find('.cmp-plan-section-spacer').toggleClass('fixed', direction === 'down');
}


function showProductCardPrice(elem, show_id) {
	let el = $(elem);
	let cycle = el.data('cycle');
	let group_id = el.data('group');
	let prices = $('div[data-group="' + group_id + '"]');
	let buttons = $('button[data-group="' + group_id + '"]');
	buttons = buttons.add(".monthBox > span[data-group='" + group_id + "']");
	buttons.removeClass("active");

	let activeButtons = $("button[data-group='" + group_id + "'][data-cycle='" + cycle + "']");
	activeButtons = activeButtons.add(".monthBox > span[data-group='" + group_id + "'][data-cycle='" + cycle + "']");
	updatePriceInformation(group_id, cycle);
	activeButtons.addClass("active");
	prices.hide();
	$('#' + show_id).show();
}
function setUpMatrixSliderCycleButton() {
	$("div.cycle-picker-source").each(function (index, elem) {
		let that = $(elem);
		let group = that.data('group');
		let btnSrc = that.html();
		$("div[data-group='" + group + "'] .cycle-picker").html(btnSrc);
	});
}
function updateMatrixSliderCycle() {
	var planSection = $('.cmp-plan-section');
	var yearTexts = planSection.find('span.yearText');
	yearTexts.each(function (index, elem) {
		let that = $(elem);
		let button_cycle = that.data('cycle');
		let button_group = that.data('group');

		let buttoninfodiv = $("#" + button_group + "-" + button_cycle + "-info");
		let months = buttoninfodiv.data('months');
		that.find('.monthValue').text(months);
	});
}
function updateMatrixSliderPrice() {
	// set the initial price info for each product card
	$(".cardBox").each(function (index, elem) {
		let that = $(elem);
		let infodiv = that.find(".pp-price-info:first");
		let button_cycle = infodiv.data('cycle');
		let button_group = infodiv.data('group');
		updatePriceInformation(button_group, button_cycle);
		that.find(".monthBox > span[data-group='" + button_group + "'][data-cycle='" + button_cycle + "']").addClass('active');
		change_price();
	});
}

function updatePriceInformation(group_id, cycle, package_id) {
	let buttoninfodiv = $("#" + group_id + "-" + cycle + "-info");
	let url = buttoninfodiv.data('buylink');
	let context = buttoninfodiv.closest('.package');
	let text = buttoninfodiv.data('buytext');
	let gtag_var = buttoninfodiv.data('varname');
	let buylink = context.find("a[data-group='" + group_id + "']");
	buylink.attr('href', url);
	buylink.attr('data-varname', gtag_var);
	buylink.off('click', gtag_click_handler);
	buylink.on('click', gtag_click_handler);
	buylink.text(text);
}

function show_10_softicons(btn_element) {
	var btn = $(btn_element);
	var hidden_articles = btn.closest('.softicons-content').find('article.softicons-out-of-view');
	var max_to_show = 10;
	var lcv = 0;
	var hit_max = false;
	hidden_articles.each(function (index, elem) {
		$(elem).removeClass('softicons-out-of-view');
		lcv++;
		if (lcv >= max_to_show) {
			hit_max = true;
			return false;
		}
	});

	if (!hit_max) {
		btn.hide();
	}
}

function navigate_to_url_prevent_default(e, url) {
	e.preventDefault;
	window.location.href = url;
}

function setupMatrixColumnLink(entry_id) {
	let context = $("#static-entry-" + entry_id);
	let matrixColumnElements = context.find('.matrix-columnlink');
	matrixColumnElements.on('mouseenter', function (event) {
		let matrixId = $(this).data('column-id');
		matrixReloaded_highlightColumn(matrixId, context, true);
	});
	matrixColumnElements.on('mouseleave', function (event) {
		let matrixId = $(this).data('column-id');
		matrixReloaded_highlightColumn(matrixId, context, false);
	});

}

function matrixReloaded_highlightColumn(columnId, context, select) {
	let matrixColumn = context.find(".matrix-columnlink[data-column-id='" + columnId + "']");
	if (select) {
		matrixColumn.addClass('focused');
		matrixColumn.removeClass('transparentBorder');
	}
	else {
		matrixColumn.addClass('transparentBorder');
		matrixColumn.removeClass('focused');
	}

}

// handle when a package tag is clicked on
function packageTagClicked(tag_element, entry_id) {
	var tag = $(tag_element);
	//single select only
	$('.package-tag[data-entry-id="' + entry_id + '"]').removeClass('active');
	tag.addClass('active');
	// else, multiselect
	//tag.toggleClass('active');
	//

	//updateDisplayForPackageTags(entry_id);

	var filterValue = tag.data('owl-filter');
	// trigger event passing this filter
	document.dispatchEvent(new CustomEvent('A2MatrixFilterChanged', { detail: { filter: filterValue, entryid: entry_id } }));

}

// update the packages that are showing based on the current active tags
function updateDisplayForPackageTags(entry_id) {
	/*
	var activeTags = $('.package-tag.active[data-entry-id="' + entry_id + '"]');
	var selected_tags = [];
	activeTags.each((index, element) => {
		selected_tags.push($(element).data('tag-name'));
	});


	var affectedElements = $('#static-entry-' + entry_id + ' .package-tag-target');
	affectedElements.each((index, element) => {
		var can_show = false;
		var that = $(element);
		package_tags = that.data('package-tags');
		for (var lcv = 0, length = selected_tags.length; lcv < length; ++lcv) {
			var page_tag = selected_tags[lcv];
			if (page_tag == '') { continue; } // skip empties
			if (package_tags.indexOf('|' + page_tag + '|') >= 0) {
				can_show = true;
				break;
			}
		}
		if (can_show) {
			that.show();
		}
		else {
			that.hide();
		}

		that.removeClass('invisible');// take off the initial invisibility, if still there
	});
	*/
}

function updatePrevNext(section) {
	var a2Prev = section.find('.synch-prev');
	var a2Next = section.find('.synch-next');

	a2Prev.removeClass("disabled");
	if (section.find("button.owl-next").hasClass("disabled")) {
		a2Next.addClass("disabled");
	} else {
		a2Next.removeClass("disabled");
	}
	if (section.find("button.owl-prev").hasClass("disabled")) {
		a2Prev.addClass("disabled");
	} else {
		a2Prev.removeClass("disabled");
	}

}



  document.addEventListener('DOMContentLoaded', function (event) {
  		change_price();
  		change_price_unmanaged_vps();
  });

function change_price(){

$('.cycle-picker.monthBox span.yearText.active:visible').click();
const product_cycle_default_overrides = {
	annually: [
	  378, 380, 381, 382, 464, 465, 466, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478
	]
  };

	for ([cycle, packageids] of Object.entries(product_cycle_default_overrides)) {
	  packageids.forEach((packageid) => {
		// get the cycle buttons for the current cycle
		const cycleButtons = document.querySelectorAll('.cycle-picker span[data-cycle="' + cycle + '"]');
		cycleButtons.forEach((elem) => {
			// check if each button is for the current package, if so click it
		  	if (elem.dataset.group.endsWith('-' + packageid)) {
				elem.click();
		  	}
		});
	  });
	}
}


function change_price_unmanaged_vps(){

$('.cycle-picker button active:visible').click();
const product_cycle_default_overrides = {
	annually: [
	  378, 380, 381, 382, 464, 465, 466, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478 
	]
  };

	for ([cycle, packageids] of Object.entries(product_cycle_default_overrides)) {
	  packageids.forEach((packageid) => {
		// get the cycle buttons for the current cycle
		const cycleButtons = document.querySelectorAll('.cycle-picker button[data-cycle="' + cycle + '"]');
		cycleButtons.forEach((elem) => {
			// check if each button is for the current package, if so click it
		  	if (elem.dataset.group.endsWith('-' + packageid)) {
				elem.click();
		  	}
		});
	  });
	}
}