﻿document.addEventListener('DOMContentLoaded', () => {
	/*
	 * clickable card
	 */
	if (document.querySelectorAll('.ppb-clickable-card')) {
		document.querySelectorAll('.ppb-clickable-card').forEach((card) => {
			let href = '';
			const parent = card.parentNode;
			if (card.querySelector('.ppb-button')) {
				href = card.querySelector('.ppb-button').href;
			} else if (parent.querySelector('.ppb-button')) {
				href = parent.querySelector('.ppb-button').href;
			} else if (card.getAttribute('imh-location')) {
				href = card.getAttribute('imh-location');
			} else if (card.querySelector('a')) {
				href = card.querySelector('a').href;
			}
			card.addEventListener('mouseover', () => {
				parent.querySelector('.ppb-button').focus();
			});
			card.addEventListener('mouseout', () => {
				parent.querySelector('.ppb-button').blur();
			});
			card.addEventListener('click', () => {
				window.location.href = href;
			});
		});
	}
});
