﻿window.addEventListener('DOMContentLoaded', (event) => {
    // Define the array containing URL prefixes to remove country codes from
		const configs = ['support', 'blog', 'legal', 'employment', 'privacy'];

    // Function to remove country code from URLs
	function fixLinks() {
        const anchors = document.querySelectorAll('a');
		// Fetch HTML language attribute used for URLs
		var urlLang = document.documentElement.lang;
        anchors.forEach(anchor => {
            let href = anchor.getAttribute('href');
            if (href) {
                // Remove country code from href if it starts with any of the specified prefixes
                for (const prefix of configs) {
                    if ( href.includes( '/' + urlLang + '/' + prefix + '/' ) ) {
                        href = href.replace( '/' + urlLang + '/' + prefix + '/', '/' + prefix + '/' );
                        anchor.setAttribute('href', href);
                        break;
                    }
                }
            }
        });
    }

    // Call the fixLinks function when the page loads
    fixLinks();
});