﻿/*!
 * Flickr's Justified Gallery [fjGallery] v2.1.2 (https://flickr-justified-gallery.nkdev.info)
 * Copyright 2022 nK <https://nkdev.info>
 * Licensed under MIT (https://github.com/nk-o/flickr-justified-gallery/blob/master/LICENSE)
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?module.exports=factory():"function"==typeof define&&define.amd?define(factory):(global="undefined"!=typeof globalThis?globalThis:global||self).fjGallery=factory()}(this,(function(){"use strict";let win;win="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};var global$1=win;function throttle(delay,callback,options){var _ref=options||{},_ref$noTrailing=_ref.noTrailing,noTrailing=void 0!==_ref$noTrailing&&_ref$noTrailing,_ref$noLeading=_ref.noLeading,noLeading=void 0!==_ref$noLeading&&_ref$noLeading,_ref$debounceMode=_ref.debounceMode,debounceMode=void 0===_ref$debounceMode?void 0:_ref$debounceMode,timeoutID,cancelled=!1,lastExec=0;function clearExistingTimeout(){timeoutID&&clearTimeout(timeoutID)}function cancel(options){var _ref2,_ref2$upcomingOnly=(options||{}).upcomingOnly,upcomingOnly=void 0!==_ref2$upcomingOnly&&_ref2$upcomingOnly;clearExistingTimeout(),cancelled=!upcomingOnly}function wrapper(){for(var _len=arguments.length,arguments_=new Array(_len),_key=0;_key<_len;_key++)arguments_[_key]=arguments[_key];var self=this,elapsed=Date.now()-lastExec;function exec(){lastExec=Date.now(),callback.apply(self,arguments_)}function clear(){timeoutID=void 0}cancelled||(noLeading||!debounceMode||timeoutID||exec(),clearExistingTimeout(),void 0===debounceMode&&elapsed>delay?noLeading?(lastExec=Date.now(),noTrailing||(timeoutID=setTimeout(debounceMode?clear:exec,delay))):exec():!0!==noTrailing&&(timeoutID=setTimeout(debounceMode?clear:exec,void 0===debounceMode?delay-elapsed:delay)))}return wrapper.cancel=cancel,wrapper}function debounce(delay,callback,options){var _ref,_ref$atBegin=(options||{}).atBegin,atBegin;return throttle(delay,callback,{debounceMode:!1!==(void 0!==_ref$atBegin&&_ref$atBegin)})}var rafSchd=function rafSchd(fn){var lastArgs=[],frameId=null,wrapperFn=function wrapperFn(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];lastArgs=args,frameId||(frameId=requestAnimationFrame((function(){frameId=null,fn.apply(void 0,lastArgs)})))};return wrapperFn.cancel=function(){frameId&&(cancelAnimationFrame(frameId),frameId=null)},wrapperFn},row={exports:{}},Row$1;(row.exports=function(params){this.top=params.top,this.left=params.left,this.width=params.width,this.spacing=params.spacing,this.targetRowHeight=params.targetRowHeight,this.targetRowHeightTolerance=params.targetRowHeightTolerance,this.minAspectRatio=this.width/params.targetRowHeight*(1-params.targetRowHeightTolerance),this.maxAspectRatio=this.width/params.targetRowHeight*(1+params.targetRowHeightTolerance),this.edgeCaseMinRowHeight=params.edgeCaseMinRowHeight,this.edgeCaseMaxRowHeight=params.edgeCaseMaxRowHeight,this.widowLayoutStyle=params.widowLayoutStyle,this.isBreakoutRow=params.isBreakoutRow,this.items=[],this.height=0}).prototype={addItem:function(itemData){var newItems=this.items.concat(itemData),rowWidthWithoutSpacing=this.width-(newItems.length-1)*this.spacing,newAspectRatio=newItems.reduce((function(sum,item){return sum+item.aspectRatio}),0),targetAspectRatio=rowWidthWithoutSpacing/this.targetRowHeight,previousRowWidthWithoutSpacing,previousAspectRatio,previousTargetAspectRatio;return this.isBreakoutRow&&0===this.items.length&&itemData.aspectRatio>=1?(this.items.push(itemData),this.completeLayout(rowWidthWithoutSpacing/itemData.aspectRatio,"justify"),!0):newAspectRatio<this.minAspectRatio?(this.items.push(Object.assign({},itemData)),!0):newAspectRatio>this.maxAspectRatio?0===this.items.length?(this.items.push(Object.assign({},itemData)),this.completeLayout(rowWidthWithoutSpacing/newAspectRatio,"justify"),!0):(previousRowWidthWithoutSpacing=this.width-(this.items.length-1)*this.spacing,previousAspectRatio=this.items.reduce((function(sum,item){return sum+item.aspectRatio}),0),previousTargetAspectRatio=previousRowWidthWithoutSpacing/this.targetRowHeight,Math.abs(newAspectRatio-targetAspectRatio)>Math.abs(previousAspectRatio-previousTargetAspectRatio)?(this.completeLayout(previousRowWidthWithoutSpacing/previousAspectRatio,"justify"),!1):(this.items.push(Object.assign({},itemData)),this.completeLayout(rowWidthWithoutSpacing/newAspectRatio,"justify"),!0)):(this.items.push(Object.assign({},itemData)),this.completeLayout(rowWidthWithoutSpacing/newAspectRatio,"justify"),!0)},isLayoutComplete:function(){return this.height>0},completeLayout:function(newHeight,widowLayoutStyle){var itemWidthSum=this.left,rowWidthWithoutSpacing=this.width-(this.items.length-1)*this.spacing,clampedToNativeRatio,clampedHeight,errorWidthPerItem,roundedCumulativeErrors,singleItemGeometry,centerOffset;(void 0===widowLayoutStyle||["justify","center","left"].indexOf(widowLayoutStyle)<0)&&(widowLayoutStyle="left"),newHeight!==(clampedHeight=Math.max(this.edgeCaseMinRowHeight,Math.min(newHeight,this.edgeCaseMaxRowHeight)))?(this.height=clampedHeight,clampedToNativeRatio=rowWidthWithoutSpacing/clampedHeight/(rowWidthWithoutSpacing/newHeight)):(this.height=newHeight,clampedToNativeRatio=1),this.items.forEach((function(item){item.top=this.top,item.width=item.aspectRatio*this.height*clampedToNativeRatio,item.height=this.height,item.left=itemWidthSum,itemWidthSum+=item.width+this.spacing}),this),"justify"===widowLayoutStyle?(itemWidthSum-=this.spacing+this.left,errorWidthPerItem=(itemWidthSum-this.width)/this.items.length,roundedCumulativeErrors=this.items.map((function(item,i){return Math.round((i+1)*errorWidthPerItem)})),1===this.items.length?(singleItemGeometry=this.items[0]).width-=Math.round(errorWidthPerItem):this.items.forEach((function(item,i){i>0?(item.left-=roundedCumulativeErrors[i-1],item.width-=roundedCumulativeErrors[i]-roundedCumulativeErrors[i-1]):item.width-=roundedCumulativeErrors[i]}))):"center"===widowLayoutStyle&&(centerOffset=(this.width-itemWidthSum)/2,this.items.forEach((function(item){item.left+=centerOffset+this.spacing}),this))},forceComplete:function(fitToWidth,rowHeight){"number"==typeof rowHeight?this.completeLayout(rowHeight,this.widowLayoutStyle):this.completeLayout(this.targetRowHeight,this.widowLayoutStyle)},getItems:function(){return this.items}};
/*!
     * Copyright 2019 SmugMug, Inc.
     * Licensed under the terms of the MIT license. Please see LICENSE file in the project root for terms.
     * @license
     */
var Row=row.exports;function createNewRow(layoutConfig,layoutData){var isBreakoutRow;return!1!==layoutConfig.fullWidthBreakoutRowCadence&&(layoutData._rows.length+1)%layoutConfig.fullWidthBreakoutRowCadence==0&&(isBreakoutRow=!0),new Row({top:layoutData._containerHeight,left:layoutConfig.containerPadding.left,width:layoutConfig.containerWidth-layoutConfig.containerPadding.left-layoutConfig.containerPadding.right,spacing:layoutConfig.boxSpacing.horizontal,targetRowHeight:layoutConfig.targetRowHeight,targetRowHeightTolerance:layoutConfig.targetRowHeightTolerance,edgeCaseMinRowHeight:.5*layoutConfig.targetRowHeight,edgeCaseMaxRowHeight:2*layoutConfig.targetRowHeight,rightToLeft:!1,isBreakoutRow:isBreakoutRow,widowLayoutStyle:layoutConfig.widowLayoutStyle})}function addRow(layoutConfig,layoutData,row){return layoutData._rows.push(row),layoutData._layoutItems=layoutData._layoutItems.concat(row.getItems()),layoutData._containerHeight+=row.height+layoutConfig.boxSpacing.vertical,row.items}function computeLayout(layoutConfig,layoutData,itemLayoutData){var laidOutItems=[],itemAdded,currentRow,nextToLastRowHeight;return layoutConfig.forceAspectRatio&&itemLayoutData.forEach((function(itemData){itemData.forcedAspectRatio=!0,itemData.aspectRatio=layoutConfig.forceAspectRatio})),itemLayoutData.some((function(itemData,i){if(isNaN(itemData.aspectRatio))throw new Error("Item "+i+" has an invalid aspect ratio");if(currentRow||(currentRow=createNewRow(layoutConfig,layoutData)),itemAdded=currentRow.addItem(itemData),currentRow.isLayoutComplete()){if(laidOutItems=laidOutItems.concat(addRow(layoutConfig,layoutData,currentRow)),layoutData._rows.length>=layoutConfig.maxNumRows)return currentRow=null,!0;if(currentRow=createNewRow(layoutConfig,layoutData),!itemAdded&&(itemAdded=currentRow.addItem(itemData),currentRow.isLayoutComplete())){if(laidOutItems=laidOutItems.concat(addRow(layoutConfig,layoutData,currentRow)),layoutData._rows.length>=layoutConfig.maxNumRows)return currentRow=null,!0;currentRow=createNewRow(layoutConfig,layoutData)}}})),currentRow&&currentRow.getItems().length&&layoutConfig.showWidows&&(layoutData._rows.length?(nextToLastRowHeight=layoutData._rows[layoutData._rows.length-1].isBreakoutRow?layoutData._rows[layoutData._rows.length-1].targetRowHeight:layoutData._rows[layoutData._rows.length-1].height,currentRow.forceComplete(!1,nextToLastRowHeight)):currentRow.forceComplete(!1),laidOutItems=laidOutItems.concat(addRow(layoutConfig,layoutData,currentRow)),layoutConfig._widowCount=currentRow.getItems().length),layoutData._containerHeight=layoutData._containerHeight-layoutConfig.boxSpacing.vertical,layoutData._containerHeight=layoutData._containerHeight+layoutConfig.containerPadding.bottom,{containerHeight:layoutData._containerHeight,widowCount:layoutConfig._widowCount,boxes:layoutData._layoutItems}}var lib=function(input,config){var layoutConfig={},layoutData={},defaults={containerWidth:1060,containerPadding:10,boxSpacing:10,targetRowHeight:320,targetRowHeightTolerance:.25,maxNumRows:Number.POSITIVE_INFINITY,forceAspectRatio:!1,showWidows:!0,fullWidthBreakoutRowCadence:!1,widowLayoutStyle:"left"},containerPadding={},boxSpacing={};return config=config||{},layoutConfig=Object.assign(defaults,config),containerPadding.top=isNaN(parseFloat(layoutConfig.containerPadding.top))?layoutConfig.containerPadding:layoutConfig.containerPadding.top,containerPadding.right=isNaN(parseFloat(layoutConfig.containerPadding.right))?layoutConfig.containerPadding:layoutConfig.containerPadding.right,containerPadding.bottom=isNaN(parseFloat(layoutConfig.containerPadding.bottom))?layoutConfig.containerPadding:layoutConfig.containerPadding.bottom,containerPadding.left=isNaN(parseFloat(layoutConfig.containerPadding.left))?layoutConfig.containerPadding:layoutConfig.containerPadding.left,boxSpacing.horizontal=isNaN(parseFloat(layoutConfig.boxSpacing.horizontal))?layoutConfig.boxSpacing:layoutConfig.boxSpacing.horizontal,boxSpacing.vertical=isNaN(parseFloat(layoutConfig.boxSpacing.vertical))?layoutConfig.boxSpacing:layoutConfig.boxSpacing.vertical,layoutConfig.containerPadding=containerPadding,layoutConfig.boxSpacing=boxSpacing,layoutData._layoutItems=[],layoutData._awakeItems=[],layoutData._inViewportItems=[],layoutData._leadingOrphans=[],layoutData._trailingOrphans=[],layoutData._containerHeight=layoutConfig.containerPadding.top,layoutData._rows=[],layoutData._orphans=[],layoutConfig._widowCount=0,computeLayout(layoutConfig,layoutData,input.map((function(item){return item.width&&item.height?{aspectRatio:item.width/item.height}:{aspectRatio:item}})))};function ready(callback){"complete"===document.readyState||"interactive"===document.readyState?callback():document.addEventListener("DOMContentLoaded",callback,{capture:!0,once:!0,passive:!0})}function getImgDimensions(img,cb){let interval,hasSize=!1,addedListeners=!1;const onHasSize=()=>{hasSize?cb(hasSize):img.naturalWidth&&(hasSize={width:img.naturalWidth,height:img.naturalHeight},cb(hasSize),clearInterval(interval),addedListeners&&removeListeners())},onLoaded=()=>{onHasSize()},onError=()=>{onHasSize()},checkSize=()=>{0<img.naturalWidth&&onHasSize()},addListeners=()=>{addedListeners=!0,img.addEventListener("load",onLoaded),img.addEventListener("error",onError)},removeListeners=()=>{addedListeners=!1,img.removeEventListener("load",onLoaded),img.removeEventListener("error",onError)};checkSize(),hasSize||(addListeners(),interval=setInterval(checkSize,100))}const fjGalleryList=[],updateFjGallery=rafSchd(()=>{fjGalleryList.forEach(item=>{item.resize()})});global$1.addEventListener("resize",updateFjGallery),global$1.addEventListener("orientationchange",updateFjGallery),global$1.addEventListener("load",updateFjGallery),ready(()=>{updateFjGallery()});let instanceID=0;class FJGallery{constructor(container,userOptions){const self=this;self.instanceID=instanceID,instanceID+=1,self.$container=container,self.images=[],self.defaults={itemSelector:".fj-gallery-item",imageSelector:"img",gutter:10,rowHeight:320,rowHeightTolerance:.25,maxRowsCount:Number.POSITIVE_INFINITY,lastRow:"left",transitionDuration:"0.3s",calculateItemsHeight:!1,resizeDebounce:100,isRtl:"rtl"===self.css(self.$container,"direction"),onInit:null,onDestroy:null,onAppendImages:null,onBeforeJustify:null,onJustify:null};const dataOptions=self.$container.dataset||{},pureDataOptions={};Object.keys(dataOptions).forEach(key=>{const loweCaseOption=key.substr(0,1).toLowerCase()+key.substr(1);loweCaseOption&&void 0!==self.defaults[loweCaseOption]&&(pureDataOptions[loweCaseOption]=dataOptions[key])}),self.options={...self.defaults,...pureDataOptions,...userOptions},self.pureOptions={...self.options},self.resize=debounce(self.options.resizeDebounce,self.resize),self.justify=rafSchd(self.justify.bind(self)),self.init()}css(el,styles){return"string"==typeof styles?global$1.getComputedStyle(el).getPropertyValue(styles):(Object.keys(styles).forEach(key=>{el.style[key]=styles[key]}),el)}applyTransition($item,properties){const self=this;this.onTransitionEnd($item)(),this.css($item,{"transition-property":properties.join(", "),"transition-duration":this.options.transitionDuration}),$item.addEventListener("transitionend",this.onTransitionEnd($item,properties),!1)}onTransitionEnd($item){const self=this;return()=>{self.css($item,{"transition-property":"","transition-duration":""}),$item.removeEventListener("transitionend",self.onTransitionEnd($item))}}addToFjGalleryList(){fjGalleryList.push(this),updateFjGallery()}removeFromFjGalleryList(){const self=this;fjGalleryList.forEach((item,key)=>{item.instanceID===self.instanceID&&fjGalleryList.splice(key,1)})}init(){const self=this;self.appendImages(self.$container.querySelectorAll(self.options.itemSelector)),self.addToFjGalleryList(),self.options.onInit&&self.options.onInit.call(self)}appendImages($images){const self=this;global$1.jQuery&&$images instanceof global$1.jQuery&&($images=$images.get()),$images&&$images.length&&($images.forEach($item=>{if($item&&!$item.fjGalleryImage&&$item.querySelector){const $image=$item.querySelector(self.options.imageSelector);if($image){$item.fjGalleryImage=self;const data={$item:$item,$image:$image,width:parseFloat($image.getAttribute("width"))||!1,height:parseFloat($image.getAttribute("height"))||!1,loadSizes(){const itemData=this;getImgDimensions($image,dimensions=>{itemData.width===dimensions.width&&itemData.height===dimensions.height||(itemData.width=dimensions.width,itemData.height=dimensions.height,self.resize())})}};data.loadSizes(),self.images.push(data)}}}),self.options.onAppendImages&&self.options.onAppendImages.call(self,[$images]),self.justify())}justify(){const self=this,justifyArray=[];self.justifyCount=(self.justifyCount||0)+1,self.options.onBeforeJustify&&self.options.onBeforeJustify.call(self),self.images.forEach(data=>{data.width&&data.height&&justifyArray.push(data.width/data.height)});const justifiedOptions={containerWidth:self.$container.getBoundingClientRect().width,containerPadding:{top:parseFloat(self.css(self.$container,"padding-top"))||0,right:parseFloat(self.css(self.$container,"padding-right"))||0,bottom:parseFloat(self.css(self.$container,"padding-bottom"))||0,left:parseFloat(self.css(self.$container,"padding-left"))||0},boxSpacing:self.options.gutter,targetRowHeight:self.options.rowHeight,targetRowHeightTolerance:self.options.rowHeightTolerance,maxNumRows:self.options.maxRowsCount,showWidows:"hide"!==self.options.lastRow},justifiedData=lib(justifyArray,justifiedOptions);if(justifiedData.widowCount&&("center"===self.options.lastRow||"right"===self.options.lastRow)){const lastItemData=justifiedData.boxes[justifiedData.boxes.length-1];let gapSize=justifiedOptions.containerWidth-lastItemData.width-lastItemData.left;"center"===self.options.lastRow&&(gapSize/=2),"right"===self.options.lastRow&&(gapSize-=justifiedOptions.containerPadding.right);for(let i=1;i<=justifiedData.widowCount;i+=1)justifiedData.boxes[justifiedData.boxes.length-i].left=justifiedData.boxes[justifiedData.boxes.length-i].left+gapSize}self.options.isRtl&&justifiedData.boxes.forEach((boxData,i)=>{justifiedData.boxes[i].left=justifiedOptions.containerWidth-justifiedData.boxes[i].left-justifiedData.boxes[i].width-justifiedOptions.containerPadding.right+justifiedOptions.containerPadding.left});let i=0,additionalTopOffset=0;const rowsMaxHeight={};self.images.forEach((data,imgI)=>{if(justifiedData.boxes[i]&&data.width&&data.height){if(self.options.calculateItemsHeight&&void 0===rowsMaxHeight[justifiedData.boxes[i].top]&&Object.keys(rowsMaxHeight).length&&(additionalTopOffset+=rowsMaxHeight[Object.keys(rowsMaxHeight).pop()]-justifiedData.boxes[imgI-1].height),self.options.transitionDuration&&1<self.justifyCount&&self.applyTransition(data.$item,["transform"]),self.css(data.$item,{display:"",position:"absolute",transform:`translateX(${justifiedData.boxes[i].left}px) translateY(${justifiedData.boxes[i].top+additionalTopOffset}px) translateZ(0)`,width:`${justifiedData.boxes[i].width}px`}),self.options.calculateItemsHeight){const rect=data.$item.getBoundingClientRect();(void 0===rowsMaxHeight[justifiedData.boxes[i].top]||rowsMaxHeight[justifiedData.boxes[i].top]<rect.height)&&(rowsMaxHeight[justifiedData.boxes[i].top]=rect.height)}i+=1}else self.css(data.$item,{display:"none"})}),self.options.calculateItemsHeight&&Object.keys(rowsMaxHeight).length&&(additionalTopOffset+=rowsMaxHeight[Object.keys(rowsMaxHeight).pop()]-justifiedData.boxes[justifiedData.boxes.length-1].height),self.options.transitionDuration&&self.applyTransition(self.$container,["height"]),self.css(self.$container,{height:`${justifiedData.containerHeight+additionalTopOffset}px`}),self.options.onJustify&&self.options.onJustify.call(self)}updateOptions(options){const self=this;this.options={...this.options,...options},this.justify()}destroy(){const self=this;self.removeFromFjGalleryList(),self.justifyCount=0,self.options.onDestroy&&self.options.onDestroy.call(self),self.css(self.$container,{height:"",transition:""}),self.images.forEach(data=>{self.css(data.$item,{position:"",transform:"",transition:"",width:"",height:""})}),self.images.forEach(val=>{delete val.$item.fjGalleryImage}),delete self.$container.fjGallery}resize(){const self=this;this.justify()}}const fjGallery=function(items,options,...args){("object"==typeof HTMLElement?items instanceof HTMLElement:items&&"object"==typeof items&&null!==items&&1===items.nodeType&&"string"==typeof items.nodeName)&&(items=[items]);const len=items.length;let k=0,ret;for(;k<len;k+=1)if("object"==typeof options||void 0===options?items[k].fjGallery||(items[k].fjGallery=new FJGallery(items[k],options)):items[k].fjGallery&&(ret=items[k].fjGallery[options].apply(items[k].fjGallery,args)),void 0!==ret)return ret;return items};fjGallery.constructor=FJGallery;const $=global$1.jQuery;if(void 0!==$){const oldInit=fjGallery.constructor.prototype.init;fjGallery.constructor.prototype.init=function(){$(this.$container).data("fjGallery",this),oldInit&&oldInit.call(this)};const oldDestroy=fjGallery.constructor.prototype.destroy;fjGallery.constructor.prototype.destroy=function(){this.$container&&$(this.$container).removeData("fjGallery"),oldDestroy&&oldDestroy.call(this)};const $Plugin=function(...args){Array.prototype.unshift.call(args,this);const res=fjGallery.apply(global$1,args);return"object"!=typeof res?res:this};$Plugin.constructor=fjGallery.constructor;const old$Plugin=$.fn.fjGallery;$.fn.fjGallery=$Plugin,$.fn.fjGallery.noConflict=function(){return $.fn.fjGallery=old$Plugin,this}}return fjGallery}));