﻿var promotion_impressions_info = [];
var promotions_slot = 1;
var product_impressions_info = [];
var checkout_info = [];
var conversion_info = [];
var product_slot = 1;
var gtag_cart_step = 1;
var gtag_cart_option = '';
var gtag_conversion_action = '';
var ecommerce_currency = 'USD';
var item_list_id = '';
var item_list_name = '';

function a2_can_gtag(check_datalayer = false) {
    if (window.dataLayer == null) {
        return false;
    }
    if (check_datalayer && window.google_tag_manager == null) {
        return false;
    }

    return true;
}

function gtag_open_link(destinationUrl, newWindow) {
    if (newWindow) {
        window.open(destinationUrl);
    }
    else {
        document.location = destinationUrl;
    }
}

function gtag_is_cart_link(url) {
    return url.indexOf('cart.php') >= 0;
}

function gtag_generate_promotion_entry(id, name, variant, position) {
    return {
        'promotion_id': id,
        'promotion_name': name,
        'creative_name': variant,
        'creative_slot': position
    };

}

function gtag_generate_product_entry(id, name, price, brand, category, variant, list, position) {
    return {
        item_id: 'I_' + id,
        item_name: name,
        item_brand: 'A2Hosting',
        item_category: category,
        item_list_name: list,
        item_variant: variant,
        price: price,
        creative_slot: position,
        quantity: 1
    }
}

function gtag_generate_cart_entry(id, name, price, brand, category, variant, qty, paymethod) {
    entry = {
        item_id: 'I_' + id,
        item_name: name,
        item_brand: 'A2Hosting',
        item_category: category,
        item_variant: variant,
        price: price,
        quantity: qty
    }
    if (paymethod) {
        // per https://developers.google.com/tag-manager/enhanced-ecommerce#purchases
        entry.dimension1 = paymethod;
    }
    return entry;
}

function gtag_promotion_clicked(entry, destinationUrl, newWindow = false) {
    if (a2_can_gtag(true)) {
        dataLayer.push({ ecommerce: null }); // Clear the previous ecommerce object.
        dataLayer.push({
            event: 'select_promotion',
            ecommerce: {
                items: [entry]
            },
            eventCallback: function (id) {
            	if (id.startsWith("GTM-")) { // prevent sending twice
			        gtag_open_link(destinationUrl, newWindow);
			    }
            },
            eventTimeout: 2000
        });
    } else {
        gtag_open_link(destinationUrl, newWindow);
    }
}


function gtag_product_clicked(entry, destinationUrl, newWindow = false) {
    if (a2_can_gtag(true)) {
        dataLayer.push({ ecommerce: null }); // Clear the previous ecommerce object.
        dataLayer.push({
            event: 'select_item',
            ecommerce: {
            	item_list_id: entry.item_list_name.replace(/ /g,"_"),
            	item_list_name: entry.item_list_name,
            	currency: ecommerce_currency,
            	value: entry.price,
                items: [entry]
            },
            eventCallback: function (id) {
            	if (id.startsWith("GTM-")) { // prevent sending twice
			        gtag_open_link(destinationUrl, newWindow);
			    }
            },
            eventTimeout: 2000
        });
    } else {
        gtag_open_link(destinationUrl, newWindow);
    }
}

function gtag_push_aggregated_ecommerce_data() {
    var ecommerce_data = {};
    if (promotion_impressions_info.length > 0) {
    	ecommerce_data = promotion_impressions_info[0];
    	ecommerce_data.items = product_impressions_info;
        dataLayer.push({
            event: 'view_promotion',
            ecommerce: ecommerce_data,
        });
    }

    if (product_impressions_info.length > 0) {

        dataLayer.push({
            event: 'view_item_list',
            ecommerce: {
            	item_list_id: item_list_name.replace(/ /g,"_"),
            	item_list_name: item_list_name,
                items: product_impressions_info
            },
        });

        ecommerce_data.items = product_impressions_info;
        ecommerce_data.currency = ecommerce_currency;
    }



    var checkout_event = false;
    if (checkout_info.length > 0) {
        checkout_event = true;
        ecommerce_data.checkout = {
            'actionField': { 'step': gtag_cart_step, 'option': gtag_cart_option },
            'products': checkout_info
        }
    }
    else if (conversion_info.length > 0) {
        ecommerce_data.purchase = gtag_conversion_action;
        ecommerce_data.purchase.items = conversion_info;
    }
    dataLayer.push({ ecommerce: null }); // Clear the previous ecommerce object.

    if (checkout_event) {
        dataLayer.push({
            'event': 'checkout',
            'ecommerce': ecommerce_data
        });
    }
    else {
        dataLayer.push({
            event: "pre_purchase",
            ecommerce: ecommerce_data.purchase
        });
    }
}

function gtag_push_userinfo() {

    var title = $('title').text();
    var locale = a2_get_site_locale(location.hostname);
    var affiliateid = a2.cookie.get('PAPAffiliateId');

    var userInfo = {
        'user_id': null, //null if not logged in
        'login_status': "Logged_out", // "Logged_in, Logged_out"
        'error_id': null,
        'affiliate_code': affiliateid ? affiliateid : null, // null if no affiliate
        'website_environment': 'dev', // prod or dev or qa
        'site_country': locale.country, // or the countries on the other domains, 2 letter code
        'site_language': locale.language, //This corresponds to the language of the website. Dynamic alphabetic, 2 letter code.
        'user_country': 'US', // As identified with userâ€™s IP
        'page_name': title, // Captures the page title for a page the customer is viewing. If the page title stays the same for multiple steps in the ecommerce flow, add the step for greater readability
    };


    // read in the cookie, and set the info on userInfo appropriately
    $client_info = a2.cookie.get_json('a2client');
    if ($client_info && $client_info['isloggedin']) {
        userInfo.login_status = "Logged_in";
        userInfo.user_id = $client_info.id;
        userInfo.user_country = $client_info.country;
    }

    if (a2_is_live_environment()) {
        userInfo.website_environment = 'prod';
    }

    window.dataLayer.push(userInfo);
}

function gtag_remove_from_cart_event(product_index) {
    if (window.dataLayer && window.google_tag_manager) {
        window.dataLayer.push({
            'event': 'removeFromCart',
            'ecommerce': {
                'remove': {                               // 'remove' actionFieldObject measures.
                    'products': {                          //  removing a product to a shopping cart.
                        'item_name': checkout_info[product_index]['name'],
                        'item_id': checkout_info[product_index]['id'],
                        'price': checkout_info[product_index]['price'],
                        'item_brand': checkout_info[product_index]['brand'],
                        'item_category': checkout_info[product_index]['category'],
                        'item_variant': checkout_info[product_index]['variant'],
                        'quantity': checkout_info[product_index]['quantity']
                    }
                }
            }
        });
    }
}

function gtag_add_to_cart_event(product_index) {
    if (window.dataLayer && window.google_tag_manager) {
        window.dataLayer.push({
            'event': 'addToCart',
            'ecommerce': {
                'add': {                               // 'add' actionFieldObject measures.
                    'products': {                          //  adding a product to a shopping cart.
                        'item_name': checkout_info[product_index]['name'],
                        'item_id': checkout_info[product_index]['id'],
                        'price': checkout_info[product_index]['price'],
                        'item_brand': checkout_info[product_index]['brand'],
                        'item_category': checkout_info[product_index]['category'],
                        'item_variant': checkout_info[product_index]['variant'],
                        'quantity': checkout_info[product_index]['quantity']
                    }
                }
            }
        });
    }
}

function gtag_click_handler(event) {
    event.preventDefault();
    var $link = $(event.currentTarget);
    var type = $link.data('ecommerce-type');
    var destinationUrl = $link.attr('href');
    var newWindow = ($link.attr('target')  == '_blank') ? true : false;

    if (type == 'product') {
        var entry = window[$link.data('varname')];
        gtag_product_clicked(entry, destinationUrl, newWindow);
    }
    else if (type == 'promotion') {
        var entry = window[$link.data('varname')];
        gtag_promotion_clicked(entry, destinationUrl, newWindow);
    }
    else if (type == 'unknown') {
        var product_entry = window[$link.data('varname-prod')];
        var promo_entry = window[$link.data('varname-promo')];
        newWindow = false;
        if (gtag_is_cart_link(destinationUrl)) {
            gtag_product_clicked(product_entry, destinationUrl, newWindow);
        } else {
            gtag_promotion_clicked(promo_entry, destinationUrl, newWindow);
        }
    }
}

document.addEventListener("DOMContentLoaded", function (event) {
    if (a2_can_gtag()) {
        gtag_push_userinfo();
        gtag_push_aggregated_ecommerce_data();
        // set up click handler for the gtag-link objects
        $('.gtag-link').click(gtag_click_handler);

        // set up click handler for standalone cta buttons
        $('.page-piece-cta-button a').click(function (event) {
            event.preventDefault();
            var $link = $(event.currentTarget);
            var $section = $link.closest('section');
            var destinationUrl = $link.attr('href');
            newWindow = false;
            var url = new URL(destinationUrl);
            var id = 'CTA-' + $section.attr('id');
            var position = $section.data('page-piece-index');
            if (gtag_is_cart_link(destinationUrl)) {
                var productId = url.searchParams.get('pid');
                var billingCycle = url.searchParams.get('billingcycle');
                var product_entry = gtag_generate_product_entry(productId, '', '', '', '', billingCycle, id, position);
                gtag_product_clicked(product_entry, destinationUrl, newWindow);
            } else {
                var promo_entry = gtag_generate_promotion_entry(id, url.pathname, 'variant1', position);
                gtag_promotion_clicked(promo_entry, destinationUrl, newWindow);
            }
        });

    }
});
