﻿/**
 * This library is shared with WHMCS client are and cart.  Make sure you check them
 * after making any changes here.
 */

/**
 * Helper function to tell if the current environment is production.
 *
 * @returns {boolean}
 */
function a2_is_live_environment(hostname = null) {
	if (hostname == null) {
		hostname = location.hostname
	}
	return (hostname == 'www.a2hosting.com' || hostname == 'a2hosting.com');
}

/**
 * Helper function to get the resource URL (EE) of the current environment.
 *
 * @returns {string}
 */
function a2_get_resource_url() {
	var current_domain = location.hostname;

	var resource_domain = (current_domain.indexOf('dev') > -1)
		? current_domain.replace('whmcs', 'web')
		: current_domain;

	resource_domain = (resource_domain.indexOf('my.') > -1)
		? resource_domain.replace('my.', 'www.')
		: resource_domain;
	return 'https://' + resource_domain;
}

/**
 * Helper function to get the country and language as determined by
 * our international domains
 *
 * @returns {object{language: {string}, country: {string}}}
 */
function a2_get_site_locale(hostname = null) {
	if (!hostname) {
		hostname = location.hostname;
	}

	var locale = { country: 'US', language: 'EN' };
	hostname = hostname.replace('www.', '');
	hostname = hostname.replace('a2hosting', '');
	hostname = hostname.replace('.com', '');
	switch (hostname) {
		case '.in':
			locale = { country: 'IN', language: 'EN' };
			break;
		case '.mx':
			var locale = { country: 'MX', language: 'ES' };
			break;
		case '.co.uk':
			var locale = { country: 'GB', language: 'EN' };
			break;
		case '.co.za':
			var locale = { country: 'ZA', language: 'EN' };
			break;
		case '.co.br':
			var locale = { country: 'BR', language: 'PT' };
			break;
		case '.es':
			var locale = { country: 'ES', language: 'ES' };
			break;
		case '.co':
			var locale = { country: 'CO', language: 'ES' };
			break;
		case '.ca':
			var locale = { country: 'CA', language: 'EN' };
			break;
		case '.id':
			var locale = { country: 'ID', language: 'EN' };
			break;
	}
	return locale;
}

var a2 = {
	get_domain: function(){
		const hostname = window.location.hostname;
		return hostname.substring(hostname.indexOf('a2hosting'));
	},
	get_whmcs_url: function () {
		var current_domain = location.hostname;
		var resource_domain = (current_domain.indexOf('dev') > -1)
			? current_domain.replace('web', 'whmcs')
			: 'my.a2hosting.com';
		return 'https://' + resource_domain;
	},
	is_whmcs: function(){
		return this.get_whmcs_url().includes(location.hostname);
	},
	cookie: {
		set: function (c_name, value, exdays, domain) {
			// strip subdomain and use browser location if none passed in
			var exdays = exdays || 120;
			var domain = domain || a2.get_domain();
			var exdate = new Date();
			exdate.setDate(exdate.getDate() + exdays);
			var c_value = value + ';path=/;domain=' + domain + ((exdays == null) ? "" : "; expires=" + exdate.toUTCString());
			document.cookie = c_name + "=" + c_value;
		},
		get: function (name) {
			var re = new RegExp(name + "=([^;]+)");
			var value = re.exec(document.cookie);
			return (value != null) ? unescape(value[1]) : null;
		},
		get_json: function (name) {
			var re = new RegExp(name + "=([^;]+)");
			var raw_value = re.exec(document.cookie);
			if (raw_value != null) {
				var value = JSON.parse(decodeURIComponent(raw_value[1]));
				return value;
			}
			return null;
		},
		whmcs: function (name, value) {
			if (name == 'currency' || name == 'language') {
				$('body').append('<img src="https://my.a2hosting.com/cart.php?' + name + '=' + value + '" id="whmcs_cur" />');
			} else {
				console.error('Only currency and language can be set in whmcs');
			}
		}
	},
	urlParameter: {
		get: function (name) {
			name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
			var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
			var results = regex.exec(location.search);
			return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
		}
	},
	test: {
		set_language: function (lang_code) {
			a2.cookie.set('language_from_browser', lang_code);
		},
	},
	// ignoring bundles for now, whmcs claims we have sold 0 of them.
	pricing: {
		get: function (packageid, options, promocode, term, callback) {
			var options_string = '';
			jQuery.each(options, function (i) {
				options_string = options_string + '&options[' + i + ']=' + options[i];
			});

			jQuery.getJSON("index.php?m=a2_pricing", 'packageid=' + packageid + '&promocode=' + promocode + options_string,
				function (data) {
					var thePrice = undefined;
					if (data != '') {

						var matchesCurrency = data.filter(function (price) {
							return price.currencycode == a2.cookie.get('currencycode');
						});

						var matchesTerm = matchesCurrency.filter(function (price) {
							return price.billingcycle == term;
						});

						if (matchesTerm[0]) {
							thePrice = matchesTerm[0];

							var renewaldate = new Date();

							renewaldate.setMonth((renewaldate.getMonth() + thePrice.months));
							thePrice.renewalDate = ('0' + (renewaldate.getMonth() + 1)).slice(-2) + '/' + ('0' + renewaldate.getDate()).slice(-2) + '/' + renewaldate.getFullYear();

							thePrice.renewalprice = thePrice.originalprice;
						}
					}

					callback(thePrice);

					if (thePrice === undefined) {
						console.log('pricing data error.  Packageid=' + packageid + ', promocode=' + promocode + ', term=' + term + ', options=' + options_string);
					}

				});
		}
	}
};

/* a2_gdpr */
var gdpr = (function () {
	var self = this;
	var notice;

	self.should_show_gdpr = function () {
		return !(a2.cookie.get('gdpr_accepted') > 0);
	};

	self.show_notice = function () {
		setTimeout(() => {
			self.notice.animate({ bottom: "0" }, 500);
		}, 5000);
	};

	self.hide_notice = function () {
		self.notice.slideUp('slow');
	};

	self.handle_click = function (ev) {
		a2.cookie.set('gdpr_accepted', Date.now(), 365);
		self.hide_notice();
	};

	self.load = function (tag_id) {
		self.notice = $(tag_id);

		self.notice.on('click', 'button', self.handle_click);

		if (self.should_show_gdpr()) {
			self.show_notice();
		}
	};

	return self;
})();

var Comm100API;
var isLoggedIn = 0;
setLoggedIn();

window.addEventListener("load", function (event) {
	gdpr.load('#gdpr_notice');
	var pagename = isLoggedIn ? 'logout' : 'clientarea';
	var login = $('.header__login');
	if(a2.is_whmcs()){
		login.attr('href', a2.get_whmcs_url() + '/' + pagename + '.php');
		login.text(isLoggedIn ? 'Log Out' : 'Login');

		$('.a2-main-header #search_box').attr('action', a2_get_resource_url()); //Change Form action to resource url

	}


	setTimeout(() => {
		Comm100API = Comm100API || {}; (function (t) { function e(e) { var a = document.createElement("script"), c = document.getElementsByTagName("script")[0]; a.type = "text/javascript", a.async = !0, a.src = e + t.site_id, c.parentNode.insertBefore(a, c) } t.chat_buttons = t.chat_buttons || [], t.chat_buttons.push({ code_plan: "e4000000-0000-0000-0000-008e000f4487", div_id: "comm100-button-e4000000-0000-0000-0000-008e000f4487" }), t.site_id = 1000583, t.main_code_plan = "e4000000-0000-0000-0000-008e000f4487", e("https://vue.comm100.com/livechat.ashx?siteId="), setTimeout(function () { t.loaded || e("https://standby.comm100vue.com/livechat.ashx?siteId=") }, 5e3) })(Comm100API || {})
		showChatMenuWhenLogged();

		if(a2.is_whmcs()) {
			Comm100API.chat_buttons.push({code_plan:"ae010000-0000-0000-0000-008e000f4487",div_id:"comm100-button-ae010000-0000-0000-0000-008e000f4487"});
		}
	}, 2000);
});

function showChatMenuWhenLogged() {
	$client_info = a2.cookie.get_json('a2client');
	var support_chat_btn = 'div#comm100-button-e4000000-0000-0000-0000-008e000f4487';
	var sales_chat_btn = 'div#comm100-button-ae010000-0000-0000-0000-008e000f4487';
	if (isLoggedIn) {
		$('.logged_in').removeClass('hidden');
		var tb = $('.a2-maintop-bar');
		tb.find('.sales_chat').addClass('hidden');
		tb.find('.support_chat').removeClass('hidden');
		//$('.header__chat_sales').addClass('hidden');
	}
	if (isLoggedIn && a2.is_whmcs()) {
		$(sales_chat_btn).addClass('d-none'); //add hidden class for support chat
	} else {
		$(support_chat_btn).addClass('d-none'); //add hidden class for support chat
	}
}

function setLoggedIn() {
	$client_info = a2.cookie.get_json('a2client');
	if ($client_info && $client_info['isloggedin']) {
		isLoggedIn = 1;
	}
}

/* end a2_gdpr */

/*
 * function to manually 'click' the live chat icon.  Only works with 'text link' style chats
 * Ids
 * Ban Page: 					dc000000-0000-0000-0000-008e000f4487
 * Bot test: 					b4010000-0000-0000-0000-008e000f4487
 * Cart Chat: 					dd000000-0000-0000-0000-008e000f4487
 * Dev Campaign: 				de000000-0000-0000-0000-008e000f4487
 * Outage: 						e2000000-0000-0000-0000-008e000f4487
 * Proactive Chat: 				e3000000-0000-0000-0000-008e000f4487
 * Sales Campaign: 				ae010000-0000-0000-0000-008e000f4487
 * Support Production Campaign: e4000000-0000-0000-0000-008e000f4487
*/
function comm100_livechat_open_link(campaignId = 'e4000000-0000-0000-0000-008e000f4487') {

	if (typeof goog_report_conversion === "function") {
		goog_report_conversion();
	}
	if (typeof Comm100API != 'undefined' && typeof Comm100API.get !== 'undefined' && Comm100API.get('livechat.button.isVisible', campaignId)) {
		Comm100API.do('livechat.button.click', campaignId);
	} else {
		alert('Chat is still loading, please wait a moment and try again.');
	}
}
/* end a2_livechat */



// MWP Pricing table Tab View Slection
jQuery(document).ready(function ($) {
    HeaderInit();
    (function ($) {
        "use strict";

    $(function() {
        $('.lazyload').Lazy({
	        scrollDirection: 'vertical',
	        effect: 'fadeIn',
	        visibleOnly: true,
	        onError: function(element) {
	            console.log('error loading ' + element.data('src'));
	        }
	    });
    });


    })(jQuery);

	  try {
	    var url_string = window.location.href;
	    var url = new URL(url_string);
	    var platforms = {'gclid':'Google', 'fbclid':'Facebook', 'msclkid':'Microsoft'};
	    for (var key in platforms) {
	      var value = a2.urlParameter.get(key);
	      if (value) {
	      	var aid_is = a2.urlParameter.get('aid');
	      	if(aid_is && aid_is != ''){
	      		var aid_is = a2.urlParameter.get('aid');
	      		const values = {created_at:Date.now(), id:value, aid:aid_is};
	      		a2.cookie.set(key, JSON.stringify(values), 90);
	      	} else {	      		const values = {created_at:Date.now(), id:value};
	      		a2.cookie.set(key, JSON.stringify(values), 90);
	      	}

	      }
	    }
	  } catch (err) {
	    //console.log("Issues with Parsing URL Parameter's - " + err);
	  }

});

/** Header Navigation changes */
function HeaderInit() {
	$('#search-toggle').on("click", function() {
        $('#mobile-search').fadeToggle().addClass("mb-2").find('.search__input').focus();
		return false;
    });
    /*---Header search---*/
	$(document).on('submit', 'form#search_box', function (e) {
		var searchBox = $('#search_box');
		if (searchBox.find('input[name="keywords"]').val().length === 0) {
			alert('Keywords are required.')
			return false;
		}

	});
	/*---404 search---*/
	$(document).on('submit', 'form#search_box_404', function (e) {
		var searchBox404 = $('#search_box_404');
		if (searchBox404.find('input[name="keywords"]').val().length === 0) {
			alert('Keywords are required.')
			return false;
		}

	});
}