﻿$(document).ready(function() {
    if ($(window).width() > 426) {
        startCarousel();
    } else {
        $('.owl-carousel').addClass('off');
        $('.owl-carousel').addClass('d-block');
        $(".testimonial-single:gt(2)").addClass('d-none');
    }
});

$(window).resize(function() {
	
    if ($(window).width() > 426) { 
        startCarousel();
    } else {
        stopCarousel();
    }
});

var showbtn = $("#show-more");

function startCarousel() {
	$(".testimonial-single").removeClass('d-none');
	showbtn.remove();
	var testimonialCarousel = $('#testimonial-carousel-id');
    testimonialCarousel.owlCarousel({
        navigation: true,
        pagination: false,
        dots: false,
        slideSpeed: 500,
        margin: 10,
        paginationSpeed: 400,
        autoplay: false,
        items: 1,
        itemsDesktop: false,
        itemsDesktopSmall: false,
        itemsTablet: false,
        itemsMobile: false,
        loop: false,
        nav: true,
        navText: ["<img class='ts-nav-img' src='https://www.a2hosting.com/wp-content/themes/a2hosting/assets/icons/left-nav.svg' alt='left navigation' width='30' height='30'>","<img  class='ts-nav-img' src='https://www.a2hosting.com/wp-content/themes/a2hosting/assets/icons/right-nav.svg' alt='right navigation' width='30' height='30'>"],
        responsive: {
            0: {
                items: 1,
            },
            426: {
                items: 1
            },
            620: {
                items: 2
            },
            769: {
                items: 3
            },
            1023: {
                items: 3
            },
            1439: {
            	items: 3
            },
            1470: {
                items: 4
            },
            2000: {
            	items: 5
            }
        }
    })

function addExtraClass() {
    testimonialCarousel.each(function() {
        var total = $(this).find('.owl-item.active').length;
        $(this).find('.owl-item').removeClass('last-active-testimonial');
        $(this).find('.owl-item.active').each(function(index) {   
            if (index === total - 1 && total > 1) {
                $(this).addClass('last-active-testimonial')
            }
        })
    })
}
addExtraClass();
testimonialCarousel.on('translated.owl.carousel', function(event) {
    addExtraClass()
});
}

function stopCarousel() {
    var owl = $('.owl-carousel');
    owl.trigger('destroy.owl.carousel');
    owl.addClass('off');
    owl.addClass('d-block');
    $(".testimonial-single:gt(2)").addClass('d-none');
    showbtn.insertAfter('#last-item');
    $("#show-more").click(function() {
    $(this).siblings(".testimonial-single:gt(2)").removeClass('d-none');
});
}


$("#show-more").click(function() {
    $(this).siblings(".testimonial-single:gt(2)").removeClass('d-none');
});